Attribute VB_Name = "Common_Application"
'Boolean values (To replace True and False)
Public Const OK As Boolean = -1
Public Const KO As Boolean = 0

'Special Characters
Public Const DOUBLE_QUOTE As String = """"
Public Const QUOTE As String = "'"
Public Const COMMA As String = ","
Public Const MARK As String = "."
Public Const ONE_SPACE As String = " "
Public Const SEP = ""                  'standard armstrong separator

'Values used to know if data are loaded or not (in the tag property for example)
Global Const Loaded As Integer = 1
Global Const UNLOADED As Integer = 0
Global Const C_ERRORRAISE As Long = 50000

Private Declare Function GetWindowRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Private Declare Function GetTempFileName Lib "Kernel32" Alias "GetTempFileNameA" (ByVal lpszPath As String, ByVal lpPrefixString As String, ByVal wUnique As Long, ByVal lpTempFilename As String) As Long
Private Declare Function SetWindowLong& Lib "user32" Alias "SetWindowLongA" _
    (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long)

Const GWL_HWNDPARENT = (-8)
Const CB_SHOWDROPDOWN = &H14F

Private Declare Function APISendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long

Public Type RECT
  Left As Long
  Top As Long
  right As Long
  bottom As Long
End Type

Public Enum ReplaceType
    rt_string = 1
    RT_Numeric = 2
    RT_Other = 3
    RT_Dollar = 4
End Enum

Public Sub GetScreenTopLeft(lo_UserControl As Object, lut_position As RECT)
Dim rCtl As RECT    'Usercontrol rectangle

    GetWindowRect lo_UserControl.hwnd, rCtl

    rCtl.Top = rCtl.Top * Screen.TwipsPerPixelY
    rCtl.Left = rCtl.Left * Screen.TwipsPerPixelX
    rCtl.right = rCtl.right * Screen.TwipsPerPixelX
    rCtl.bottom = rCtl.bottom * Screen.TwipsPerPixelY
    
    lut_position = rCtl

End Sub

Public Function SetOwner(ByVal HwndtoUse As Long, ByVal HwndofOwner As Long) As Long
    SetOwner = SetWindowLong(HwndtoUse, GWL_HWNDPARENT, HwndofOwner)
End Function

Public Sub FrameEnabled(ao_Form As Object, ao_Frame As Frame, ab_Enabled As Boolean)
' Purpose : Enabled or disabled ALL the components of the frame
'
' Parameters :  ms_Frame: Name of the frame to disabled or enabled
'               mb_Enabled: Set enabled or disabled (OK or KO)
'------------------------------------------------------------------
Dim li_Count As Integer
Dim ls_Frame As String
    ls_Frame = ao_Frame.Name
    For li_Count = 0 To ao_Form.Controls.Count - 1
        If ao_Form.Controls(li_Count).Container.Name = ls_Frame Then ao_Form.Controls(li_Count).Enabled = ab_Enabled
    Next
    ao_Form.Controls(ls_Frame).Enabled = ab_Enabled
End Sub

Public Sub GridClear(lo_Grid As Object)
'------------------------------------------------------------------
' Name : GridClear
'
' Purpose : Clear the component Grid
'
' Parameters :
'       lo_Grid           The Grid to clear
'
' Return : Nothing
'
' review :
'------------------------------------------------------------------
Dim li_Count As Integer

    lo_Grid.Rows = 1
    For li_Count = 0 To lo_Grid.Cols - 1
        lo_Grid.Col = li_Count
        lo_Grid.Text = ""
    Next li_Count

End Sub

Public Sub MouseOn()
'------------------------------------------------------------------
' Name : MouseOn
'
' Purpose : Turn the mouse pointer to arrow
'
' Parameters : Nothing
'
' Return : Nothing
'
' review : Jan/06/2000 by AD
'------------------------------------------------------------------
    Screen.MousePointer = 0
End Sub

Public Sub MouseOff()
'------------------------------------------------------------------
' Name : MouseOff
'
' Purpose : Turn the mouse pointer to busy
'
' Parameters : Nothing
'
' Return : Nothing
'
' review : Jan/06/2000 by AD
'------------------------------------------------------------------
    Screen.MousePointer = 11
End Sub

Private Sub GridSwapLine(lo_Grid As Object, li_FirstLine As Long, li_SecondLine As Long)
Dim lv_TempValue, lv_TempValue1
Dim i As Integer

    If li_FirstLine = li_SecondLine Then Exit Sub

    For i = 0 To lo_Grid.Cols - 1
    
        lo_Grid.Col = i
        lo_Grid.Row = li_FirstLine
        lv_TempValue = lo_Grid.Text
        lo_Grid.Row = li_SecondLine
        lv_TempValue1 = lo_Grid.Text
        lo_Grid.Text = lv_TempValue
        lo_Grid.Row = li_FirstLine
        lo_Grid.Text = lv_TempValue1
    
    Next

End Sub
    
Private Function GridCompareLine(lo_Grid As Object, a_numcol, a_coltype, li_FirstLine As Long, li_SecondLine As Long) As Integer
Dim k As Integer
Dim ls_Text() As String
Dim li_ColumnNumber As Long
    
    li_ColumnNumber = UBound(a_numcol, 1)
    
    'Make an array of the size of the column number to sort
    ReDim ls_Text(li_ColumnNumber)
    
    If li_FirstLine = li_SecondLine Then
        GridCompareLine = 0
        Exit Function
        End If
        
    lo_Grid.Row = li_FirstLine
        
    ' keep in ls_text() only columns that are in the sort
    For k = 0 To li_ColumnNumber
        lo_Grid.Col = a_numcol(k)
        ls_Text(k) = lo_Grid.Text
    Next k
            
    lo_Grid.Row = li_SecondLine
    For k = 0 To li_ColumnNumber
        'We check all column to sort
        lo_Grid.Col = a_numcol(k)
        If a_coltype(k) = KO Then
            If StrComp(ls_Text(k), lo_Grid.Text, 1) = 1 Then
                GridCompareLine = 1
                Exit Function
            End If
                Else
            If StringToFloat(ls_Text(k)) > StringToFloat(lo_Grid.Text) Then
                GridCompareLine = 1
                Exit Function
                    End If
                End If
        If ls_Text(k) <> lo_Grid.Text Then
            GridCompareLine = -1
            Exit Function
        End If
    Next k
    GridCompareLine = 0

End Function

Public Sub GridSortOneLine(lo_Grid As Object, a_numcol, a_coltype, Optional a_RowToSort As Variant)
Dim i As Long
Dim Col As Long
Dim line As String
Dim RowToSort As Long
Dim Position As Long
            
    Position = -1
        
    If IsMissing(a_RowToSort) Then
        RowToSort = lo_Grid.Rows - 1
                Else
        RowToSort = a_RowToSort
                    End If

    i = RowToSort - 1

    Do While i > 0 And GridCompareLine(lo_Grid, a_numcol, a_coltype, i, RowToSort) >= 0
        i = i - 1
    Loop

    i = i + 1

    If i <> RowToSort Then
        Position = i
            Else
        
        i = RowToSort + 1
    
        Do While i <= lo_Grid.Rows - 1 And GridCompareLine(lo_Grid, a_numcol, a_coltype, RowToSort, i) > 0
            i = i + 1
            If i = lo_Grid.Rows Then Exit Do
        Loop

        If i <> RowToSort + 1 Then Position = i

            End If

    If Position = -1 Then Exit Sub

    line = ""
    lo_Grid.Row = RowToSort
    For Col = 0 To lo_Grid.Cols - 1
        lo_Grid.Col = Col
        line = line & lo_Grid.Text & vbTab
    Next Col
    lo_Grid.RemoveItem RowToSort
    
    If Position > RowToSort Then Position = Position - 1
    
    lo_Grid.AddItem line, Position

End Sub

Public Sub GridSort(lo_Grid As Object, a_numcol, a_coltype, Optional a_RowBegin As Variant, Optional a_RowEnd As Variant)
Dim iFirst As Long, iLast As Long, iRand As Long
Dim iSel As Long

    If IsMissing(a_RowBegin) Then iFirst = 1 Else iFirst = a_RowBegin
    If IsMissing(a_RowEnd) Then iLast = lo_Grid.Rows - 1 Else iLast = a_RowEnd
    
    iSel = lo_Grid.Row
    
    If iFirst < iLast Then
        ' Only two elements in this subdivision; exchange if
        ' they are out of order, and end recursive calls
        If iLast - iFirst = 1 Then
            If GridCompareLine(lo_Grid, a_numcol, a_coltype, iFirst, iLast) > 0 Then
                If iFirst <> iLast And iFirst = iSel Then
                    iSel = iLast
                Else
                    If iFirst <> iLast And iLast = iSel Then
                        iSel = iFirst
                    End If
                End If
                GridSwapLine lo_Grid, iFirst, iLast
            End If
            lo_Grid.Row = iSel
        Else
            Dim iLo As Long, iHi As Long
            
            Randomize
            iRand = Int((iLast - iFirst + 1) * Rnd + iFirst)
    
            ' Pick pivot element at random and move to end
            'GridSwapLine lo_Grid, iLast, iRand
            iLo = iFirst
            iHi = iLast
            Do
                ' Move in from both sides toward pivot element
                Do While (iLo < iRand) And _
                    GridCompareLine(lo_Grid, a_numcol, a_coltype, iLo, iRand) <= 0
                    iLo = iLo + 1
                Loop
        
                iLo = iLo
        
                Do While (iHi > iRand) And _
                    GridCompareLine(lo_Grid, a_numcol, a_coltype, iHi, iRand) >= 0
                    iHi = iHi - 1
                Loop
                ' If you havent reached pivot element, it means
                ' that two elements on either side are out of
                ' order, so swap them
                If iLo < iHi Then
                    If iLo <> iHi And iLo = iSel Then
                        iSel = iHi
                    Else
                        If iLo <> iHi And iHi = iSel Then
                            iSel = iLo
                        End If
                    End If
                    GridSwapLine lo_Grid, iLo, iHi
                    Select Case iRand
                        Case iLo: iRand = iHi
                        Case iHi: iRand = iLo
                    End Select
                End If
            Loop While iLo < iHi
            
            ' Move pivot element back to its proper place
            'GridSwapLine lo_Grid, iLo, iLast
            ' Recursively call SortArrayRec (pass smaller
            ' subdivision first to use less stack space)
            If (iLo - iFirst) < (iLast - iLo) Then
                lo_Grid.Row = iSel
                GridSort lo_Grid, a_numcol, a_coltype, iFirst, iLo - 1
                GridSort lo_Grid, a_numcol, a_coltype, iLo + 1, iLast
            Else
                lo_Grid.Row = iSel
                GridSort lo_Grid, a_numcol, a_coltype, iLo + 1, iLast
                GridSort lo_Grid, a_numcol, a_coltype, iFirst, iLo - 1
            End If
        End If
    End If
End Sub

Function GetValueLine(ByVal ls_CommandLine As String)
'------------------------------------------------------------------
' Name : GetValueLine
'
' Purpose : Return an array of each value in the string (command line)
'           It's support double quote and spaces.
'
' Parameters :
'       ls_String           Command line to convert into array
'
' Return :
'       An array of arguments of the command line
'
' review : Jan/07/2000 by AD (To Rewrite)
'------------------------------------------------------------------
  
  
Dim c As String
Dim lb_InQuote As Boolean
Dim lb_NewCmdLine As Boolean
Dim lb_InArg As Boolean
Dim i As Long
Dim li_NumArgs As Integer
Dim la_Arguments()

    'Create an empty Array
    ReDim la_Arguments(0)
    
    'There are no argument
    li_NumArgs = 0
    lb_InArg = KO
    
    'Go thru command line one character
    'at a time.
    For i = 1 To Len(ls_CommandLine)
        c = Mid(ls_CommandLine, i, 1)
      
        If lb_InQuote = OK And c = DOUBLE_QUOTE Then
            lb_InQuote = KO
        Else
            If lb_InQuote = KO And c = DOUBLE_QUOTE Then lb_InQuote = OK
        End If
        
        'If we have a space and we are not beetween lb_InQuotes, We begin a new argument
        If (c = ONE_SPACE And lb_InQuote = KO) Then lb_NewCmdLine = OK

        'Test for space or tab
        If lb_NewCmdLine = KO Then
            'It's not a new argument
            
            'Test if we was already in an argument
            If lb_InArg = KO Then
                'a New argument begins

                'Make array of the correct size
                li_NumArgs = li_NumArgs + 1
                ReDim Preserve la_Arguments(li_NumArgs)
                'Now, We are in an argument
                lb_InArg = OK
            End If
         
            'Concatenate character to current argument if it's not a lb_InQuote
            If c <> DOUBLE_QUOTE Then la_Arguments(li_NumArgs) = la_Arguments(li_NumArgs) & c
        Else
            'We have ended the last argument
            lb_InArg = KO
            lb_NewCmdLine = KO
        End If
    Next i
    
    'Returns Array
    GetValueLine = la_Arguments()

End Function

Public Function GetTempName(ls_Rep As String, ls_TmpFilePrefix As String, ls_drive As String, ls_path As String, ls_FileName As String) As Boolean
'------------------------------------------------------------------
' Name : GetTempName
'
' Purpose : Return a temporary name
'
' Parameters :
'   ls_rep              Directory where you want to create a temporary file
'   ls_TmpFilePrefix    Prefixe of the temporary file to create
'   ls_drive            Drive of the created file
'   ls_path             Path of the created file
'   ls_Filename         Name of the created file
'
' Return :
'       OK if success or KO
'
' review : Mar/28/2000 by AD
'------------------------------------------------------------------
Dim ls_TempFileName As String * 256
Dim ls_tempStr As String
Dim ls_DriveName As String
Dim li_Pos As Integer
Dim li_CurrPos As Integer
Dim li_StartPos As Integer

    GetTempName = KO
    
    On Error GoTo GetTempName_Err

    ls_DriveName = ls_Rep
    'Ask the temporary name to Windows
    If GetTempFileName(ls_DriveName, ls_TmpFilePrefix, 0, ls_TempFileName) = KO Then
        'Windows cannot create a temporary file
        ls_drive = ""
        ls_path = ""
        ls_FileName = ""
        Exit Function
    End If
    
    'Read the temporary String
    ls_tempStr = Left$(ls_TempFileName, InStr(ls_TempFileName, Chr(0)) - 1)
    'Read the drive
    ls_drive = Left(ls_tempStr, 1)
    
    'Read the path
    li_CurrPos = 0
    li_StartPos = 1
    li_Pos = InStr(li_StartPos, ls_tempStr, "\", vbBinaryCompare)
    Do While li_Pos > 0
        li_CurrPos = li_Pos
        li_StartPos = li_Pos + 1
        li_Pos = InStr(li_StartPos, ls_tempStr, "\", vbBinaryCompare)
    Loop
    ls_path = Mid(ls_tempStr, 3, li_CurrPos - 2)
    
    'Rad the filename
    ls_FileName = right(ls_tempStr, Len(ls_tempStr) - li_CurrPos)
    
    GetTempName = OK
    
    Exit Function
    
GetTempName_Err:
    ls_drive = ""
    ls_path = ""
    ls_FileName = ""

End Function

Public Function SoundLike(ByVal ls_Ref As String, ByVal ls_Compare As String) As Integer
'------------------------------------------------------------------
' Name : SoundLike
'
' Purpose : Compare two string and return the number of first characteres equal
'
' Parameters :
'       ls_Ref      : a string to compare
'       ls_Compare  : a string
'
' Return :
'   return the number of first characteres equal
'
' review : 27/Oct/1999 by JJB
'------------------------------------------------------------------
Dim ls_TempRef As String
Dim ls_TempCompare As String
Dim li_CurrChar As Integer
    ls_TempRef = ls_Ref
    ls_TempCompare = ls_Compare
    If Len(ls_TempRef) > 1 And Len(ls_TempCompare) > 1 Then
        For li_CurrChar = 1 To Len(ls_Ref)
            If Left(ls_TempRef, 1) <> Left(ls_TempCompare, 1) Then
                Exit For
            End If
            If Len(ls_TempRef) > 1 And Len(ls_TempCompare) > 1 Then
                ls_TempRef = right(ls_TempRef, Len(ls_TempRef) - 1)
                ls_TempCompare = right(ls_TempCompare, Len(ls_TempCompare) - 1)
            Else
                Exit For
            End If
        Next li_CurrChar
        SoundLike = li_CurrChar - 1
    Else
        SoundLike = 0
    End If
End Function

Public Function QuoteParam(ByVal ls_String As String)
'------------------------------------------------------------------
' Name : QuoteParam
'
' Purpose : Verify if the string has quote char and double them if
'           necessary
'
' Parameters :
'       ll_Environment      Environement identifier
'       ll_Database         Database identifier
'
' review : Sep/17/1999 by AD
'------------------------------------------------------------------
Dim ls_Out As String
Dim li_Position As Integer
Dim li_Length As Integer
Dim i As Integer
Dim j As Integer
    
    li_Position = InStr(ls_String, QUOTE)
    If li_Position > 0 Then
        ls_Out = ""
        
        li_Length = Len(ls_String)
        j = 1
        For i = 1 To li_Length
            li_Position = InStr(j, ls_String, QUOTE)
            If li_Position > 0 Then
                ls_Out = ls_Out & Mid(ls_String, j, (li_Position - j)) & "''"
                j = li_Position + 1
            Else
                ls_Out = ls_Out & Mid(ls_String, j)
                Exit For
            End If
            i = li_Position
        Next
        
        QuoteParam = ls_Out
    Else
        QuoteParam = ls_String
    End If

End Function

Public Sub StdError()
'------------------------------------------------------------------
' Name : StdError
'
' Purpose : Send an error message to the user
'
' Parameters : Nothing
'
' Return : Nothing
'
' review : Mar/28/2000 by AD
'------------------------------------------------------------------
    
    gs_message = "Error n " & Str(Err.Number) & " generated by " _
    & Err.Source & Chr(13) & Err.Description
    MouseOn
    MsgBox gs_message, , "Error", Err.HelpFile, Err.HelpContext
    MouseOff

End Sub

Public Function Formatage2(ls_Text As String) As String

Dim ls_Left As String
Dim ls_Right As String
Dim i As Integer

i = InStr(1, ls_Text, ",", vbTextCompare)
If i <> 0 Then
    ls_Text = Mid(ls_Text, 1, i - 1) & "." & Mid(ls_Text, i + 1, Len(ls_Text) - i)
End If

If ls_Text = "" Then ls_Text = "0"
While (Left(ls_Text, 1) = "0" And Left(ls_Text, 2) <> "0." And Len(ls_Text) > 1) Or (Left(ls_Text, 1) = " ")
    ls_Text = right(ls_Text, Len(ls_Text) - 1)
Wend
If InStr(1, ls_Text, ".", vbTextCompare) <> 0 Then
    ls_Left = Left(ls_Text, InStr(1, ls_Text, ".", vbTextCompare) - 1)
    ls_Right = right(ls_Text, Len(ls_Text) - Len(ls_Left) - 1)
    If ls_Left = "" Then ls_Left = "0"
    ls_Left = Format(ls_Left, "0")
    Formatage2 = ls_Left
    Formatage2 = Formatage2 & "." & ls_Right
Else
    Formatage2 = ls_Text
End If

End Function



Public Function FormatD(ls_Date As String, ls_Format As String) As String


If ls_Date = "" Then
        FormatD = ""
        Exit Function
End If
Select Case ls_Format
Case "mm/dd/yyyy"
    FormatD = Mid(ls_Date, 4, 2) & "/" & Mid(ls_Date, 1, 2) & "/" & Mid(ls_Date, 7, 4)
Case "yyyymmdd"
    FormatD = Mid(ls_Date, 7, 4) & Mid(ls_Date, 4, 2) & Mid(ls_Date, 1, 2)
Case "ddd dd/mm/yyyy"
    FormatD = Format(DateSerial(Mid(ls_Date, 7, 4), Mid(ls_Date, 4, 2), Mid(ls_Date, 1, 2)), "ddd") & " " & ls_Date
End Select

End Function

Public Sub DropDown(lo_Combobox As Object)
    APISendMessage lo_Combobox.hwnd, CB_SHOWDROPDOWN, True, 0
End Sub

Function CompareDateTime(ls_ServerDate As String, ls_ServerTime As String, ls_LocalDate As String, ls_LocalTime As String) As Integer
' -1 if the server date and time is greater
' 0 if the both date and time are equal
' 1 if the local date and time is greater
' -2 Error

    CompareDateTime = -2
    If ls_ServerDate = "" Or ls_ServerTime = "" Or ls_LocalDate = "" Or ls_LocalTime = "" Then Exit Function

    If StringToDate(ls_ServerDate) > StringToDate(ls_LocalDate) Then
        CompareDateTime = -1
    Else
        If StringToDate(ls_ServerDate) < StringToDate(ls_LocalDate) Then
            CompareDateTime = 1
        Else
            If ls_ServerTime > ls_LocalTime Then
                CompareDateTime = -1
            Else
                If ls_ServerTime < ls_LocalTime Then
                    CompareDateTime = 1
                Else
                    CompareDateTime = 0
                End If
            End If
        End If
    End If

End Function

Function SplitString(ByVal ls_String As String, ByVal ls_Separator As String)
Dim StringArray() As String
Dim li_LenString As Integer
Dim li_Curs As Integer
Dim lb_NewElement As Boolean
Dim li_ElementCount As Integer
Dim ls_char As String
    ReDim StringArray(0)
    
    li_LenString = Len(ls_String)
    lb_NewElement = KO
    li_ElementCount = 0
    
    For li_Curs = 1 To li_LenString
        ls_char = Mid(ls_String, li_Curs, 1)
        If ls_char = ls_Separator Then
            lb_NewElement = OK
        End If
        If lb_NewElement Then
            li_ElementCount = li_ElementCount + 1
            ReDim Preserve StringArray(li_ElementCount)
            lb_NewElement = KO
        Else
            StringArray(li_ElementCount) = StringArray(li_ElementCount) & ls_char
        End If
    Next
        
    'Return result Array in Function name.
    SplitString = StringArray()
    ReDim StringArray(0)
End Function


Public Function StringToFloat(ls_String As String) As Single

Dim ls_Left As String
Dim ls_Right As String
Dim li_Pos As Integer

li_Pos = InStr(1, ls_String, ".", 1)
If li_Pos = 0 Then
    StringToFloat = Val(ls_String)
Else
    ls_Left = Left(ls_String, li_Pos - 1)
    ls_Right = right(ls_String, Len(ls_String) - li_Pos)
    StringToFloat = Val(ls_Left) + Val(ls_Right) * 10 ^ (-(Len(ls_String) - li_Pos))
End If

End Function


Public Function StringToDate(ls_Date As String) As Date

StringToDate = DateSerial(Mid(ls_Date, 7, 4), Mid(ls_Date, 4, 2), Mid(ls_Date, 1, 2))

End Function

Public Function CompareDate_FR(as_Date1 As Date, Optional as_Date2) As Integer
' Compare 2 dates if date2  is missing Now is assumed
'-1 if the first date is lower
' 0 if dates  are equal
' 1 if the first date is greater
' -2 Error
Dim ls_Date1 As String
Dim ls_Date2 As String

CompareDate_FR = -2

ls_Date1 = Format(Year(as_Date1), "0000") & Format(Month(as_Date1), "00") & Format(Day(as_Date1), "00")

If IsMissing(as_Date2) Then
    ls_Date2 = Format(Year(Now), "0000") & Format(Month(Now), "00") & Format(Day(Now), "00")
End If

If CLng(ls_Date1) > CLng(ls_Date2) Then
    CompareDate_FR = 1
End If
If CLng(ls_Date1) = CLng(ls_Date2) Then
    CompareDate_FR = 0
End If
If CLng(ls_Date1) < CLng(ls_Date2) Then
    CompareDate_FR = -1
End If
Exit Function

End Function

Public Sub ChangeCharset(ByRef lo_Form As Form)
Dim lo_Control As Control
    
    On Error Resume Next

    lo_Form.Font.Charset = GetCharSetFromCodePage(gl_CodePage)

    For Each lo_Control In lo_Form.Controls
        lo_Control.Font.Charset = GetCharSetFromCodePage(gl_CodePage)
    Next
End Sub

Public Function ReplaceString(ByVal as_String As String, ByVal as_Replace As String, as_Value As String, Optional aet_Type As ReplaceType = RT_Other) As String
Dim ls_value As String

    Select Case aet_Type
        Case rt_string
            ls_value = QuoteParam(as_Value)
        Case RT_Numeric
            ls_value = FormatNumericValue(as_Value)
        Case RT_Other
            ls_value = as_Value
        Case RT_Dollar
            as_Replace = "$" & as_Replace & "$"
            ls_value = as_Value
    End Select
    ReplaceString = Replace(as_String, as_Replace, ls_value, , , vbTextCompare)

End Function

Public Function DecimalSeparator() As String
    DecimalSeparator = Mid(Format("0", "0.0"), 2, 1)
End Function

Public Function NegativeSymbol() As String
    NegativeSymbol = Mid(Format("-1", "0"), 1, 1)
End Function

Public Function IsNumericValue(as_Text As String, Optional ab_IntegerOnly As Boolean = False) As Boolean
Dim i As Integer
Dim ls_DecimalSeparator As String
Dim lb_First As Boolean
Dim li_Begin As Integer
Dim li_End As Integer

    On Error GoTo IsNumericValue_Err
    
    ls_DecimalSeparator = DecimalSeparator
    If Left(as_Text, 1) = NegativeSymbol Or Left(as_Text, 1) = "-" Then
        li_Begin = 2
    Else
        li_Begin = 1
    End If
    If right(as_Text, 1) = NegativeSymbol Or right(as_Text, 1) = "-" Then
        li_End = Len(as_Text) - 1
    Else
        li_End = Len(as_Text)
    End If
    
    IsNumericValue = False
    If ab_IntegerOnly = True Then
        lb_First = True
    Else
        lb_First = False
    End If
    For i = li_Begin To li_End
        ls_char = Mid(as_Text, i, 1)
        If Not isNumeric(ls_char) Then
            If (ls_char = "." Or ls_char = ls_DecimalSeparator) And Not lb_First Then
                lb_First = True
            Else
                Exit Function
            End If
        End If
    Next i
    IsNumericValue = True

    Exit Function

IsNumericValue_Err:

End Function

Public Function FormatNumericValue(as_Text As String) As String
Dim i As Integer
Dim ls_DecimalSeparator As String
Dim ls_NegativeSymbol As String
Dim ls_Text As String
    
    On Error GoTo FormatNumericValue_Err
    
    FormatNumericValue = ""
    
    ls_DecimalSeparator = DecimalSeparator
    ls_NegativeSymbol = NegativeSymbol
    ls_Text = as_Text
    ls_Text = Replace(ls_Text, ls_NegativeSymbol, "-")
    ls_Text = Replace(ls_Text, ls_DecimalSeparator, ".")
    If right(ls_Text, 1) = "-" Then
        ls_Text = "-" & Left(ls_Text, Len(ls_Text) - 1)
    End If

    FormatNumericValue = ls_Text

    Exit Function

FormatNumericValue_Err:

End Function

Public Function FormatStringToNumericValue(as_Text As String) As String
Dim i As Integer
Dim ls_DecimalSeparator As String
Dim ls_NegativeSymbol As String
Dim ls_Text As String
    
    On Error GoTo FormatStringToNumericValue_Err
    
    FormatStringToNumericValue = ""
    
    ls_DecimalSeparator = DecimalSeparator
    ls_NegativeSymbol = NegativeSymbol
    ls_Text = as_Text
    ls_Text = Replace(ls_Text, "-", ls_NegativeSymbol)
    ls_Text = Replace(ls_Text, ".", ls_DecimalSeparator)
    ls_Text = Replace(ls_Text, ",", ls_DecimalSeparator)
    If right(ls_Text, 1) = "-" Then
        ls_Text = "-" & Left(ls_Text, Len(ls_Text) - 1)
    End If

    FormatStringToNumericValue = ls_Text

    Exit Function

FormatStringToNumericValue_Err:

End Function

Public Sub UploadSQLError(ByRef ao_Armdb As Object, ByRef ao_ArmdbErr As Object, ByVal as_Procedure As String)
Dim ls_Req As String, lStr As String, lNumber As Long, lDesc As String

Const C_ERR_FATAL_MSG As String = "A fatal error occured, the application will be terminated. Please report error to IT support team" & vbCrLf & "Error : "
Const C_ERR_REPORT As String = "Please, report this to IT application support"


lNumber = Err.Number
lDesc = Err.Description

On Error GoTo onError

If ao_Armdb.LastErrorCode = 0 Then
    If lNumber <> 0 Then
        'error runtime
        as_Procedure = "VB runtime : " & as_Procedure
        ls_Req = "EXEC Error_Log_Insert '" & App.EXEName & "', '" & App.Major & "." & App.Minor & "." & App.Revision & "', '" _
            & QuoteParam(as_Procedure) & "', '" & lNumber & "','" & lDesc & "'"
        If Not ao_ArmdbErr.ExecuteSQL(ls_Req) Then
            'debug.print "Impossible to insert in Error log  "
        End If
    Else
        'debug.print "Call to UploadSQLError not relevant : " & as_Procedure
        Exit Sub
    End If
Else
    'In case of armsyscom failure
    If IsEmpty(ao_Armdb.SQLErrorCodes) Then Err.Raise C_ERRORRAISE, "UploadSQLError", "Fatal error in armsyscom : SQlErrorCodes is empty although LastErrorCode = " & ao_Armdb.LastErrorCode
    If IsEmpty(ao_Armdb.SQLErrorMessages) Then Err.Raise C_ERRORRAISE, "UploadSQLError", "Fatal error in armsyscom : SQLErrorMessages is empty although LastErrorCode = " & ao_Armdb.LastErrorCode
    
    
    Dim lErrMsg As Variant, lErrCode As Variant
    Dim lIdx As Long, lCount As Long, lCount2 As Long
        
    lStr = "An error occured : " & as_Procedure & vbCrLf
        
    '  On contourne le bug  l'aide de variables locales, le bug empche d'accder au lment du variant mais pas au variant lui mme
    lErrCode = ao_Armdb.SQLErrorCodes
    lErrMsg = ao_Armdb.SQLErrorMessages
        
    lCount = UBound(lErrCode)
    lCount2 = UBound(lErrMsg)
         
    'If not it may cause a runtime error (index out of bound)
    If lCount = lCount2 Then
        For lIdx = 0 To lCount
            lStr = lStr & "Err : " & lErrCode(lIdx) & ", " & lErrMsg(lIdx)
        Next
    Else
            lStr = lStr & "Errs : " & Join(lErrCode, ", ") & vbCrLf & "Msg : " & Join(lErrMsg, vbCrLf) & vbCrLf & C_ERR_REPORT
    End If
        
    ls_Req = "EXEC Error_Log_Insert '" & App.EXEName & "', '" & App.Major & "." & App.Minor & "." & App.Revision & "', '" _
        & QuoteParam(as_Procedure) & "', 'UploadSQLError','" & QuoteParam(lStr) & "'"
    If Not ao_ArmdbErr.ExecuteSQL(ls_Req) Then
        'debug.print "Impossible to insert in Error log  "
    End If
End If
    
Exit Sub

onError:
    ao_Armdb.disconnect
    MsgBox C_ERR_FATAL_MSG & lNumber & ", " & lDesc, vbCritical
        
    End
End Sub

